



;=====================================================================================================================================================
;																									
;	( PIEL-09 )	 	*** FUNCIONA ***																			
;																									
;					DESAROLLA PIEL ENTRE SECCIONES TRANSVERSALES (a lo ANCHO)											
;																									
;																									
;					** SPLINES-PLANAS ** ABIERTAS ** en PLANOS NO PARALELOS **											
;																									
;					(SPLI-X)    GRADUA (DISgra) (SPLINE-A) (SPLINE-B) => Puntos ( LIS-PA+mar ) ( LIS-PB+mar )						
;																									
;					(TRAZA-AB)  INTERSECCION PLANO (SPLINE-A) com PLANO (SPLINE-B) => (TRAZ-1) (TRAZ-2)							
;																									
;					LISTA-ANGLOS TANGENTES EN P2 AL CIRCULO OSCULADOR A P1 P2 P3										
;																									

;																									
;																									
;=====================================================================================================================================================



;=====================================================================================================================================================
;									*** ***  SUB-PROGRAMAS  *** ***											
;=====================================================================================================================================================


;	PINTA PUNTOS de (LIS-PX) con Texto-N   (COMPROVACION)															

	(DEFUN PINTA-PUN ( / )

		(SETQ N1 -1 )
		(REPEAT (LENGTH LIS-PINTA-P)
			(SETQ N1 (+ N1 1))
			(SETQ PAAn (NTH N1 LIS-PINTA-P))
			(COMMAND "COLOR" COLO "PUNTO" PAAn)  ; COLO
			; (COMMAND "TEXTO" PAAn 0.02 90 N1)
		) ; repeat

	) ; PINTA-PUN

;																									


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	SPLINE-X   GRADUA SPLINE ( NX00 ) con ( DISgra ) => LISTA PUNTOS ( LIS-PX+2 )  											
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	ENTRADA  : / NX00 / DISgra /																				
;	INTERNAS : / ALIS / AELE / AELES / X-primer / X-ultimo / N-enti-A1 / LIS-PX / W1A / N-enti-A2 / PX-primer / PX-ultimo /    / N1 / PAAn / 		
;	SALIDA   : / LIS-PX+2 /																					
;-----------------------------------------------------------------------------------------------------------------------------------------------------


	(DEFUN SPLI-X ( / )

		(SETQ ALIS  (ENTGET NX00))  									; lista Spline A
		(SETQ AELE  (ASSOC 10 ALIS))  								; 1 Punto Asociado a 10 (10.punto)
		(SETQ AELES (MEMBER AELE ALIS)) 								; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ X-primer (CDR (NTH 0 AELES))) 							; primer elemento (10.punto)
		(SETQ X-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))				; ultimo elemento (11.punto)
		(COMMAND "COLOR" COLO "TEXTO" X-primer 0.2 90 TEX)					; TEXTO = A
		(COMMAND "PUNTO" X-primer)									; PINTA 1 punto A
		(SETQ N-enti-A1 (ENTLAST))									; nombre ultima entidad principal 1 punto A
		(COMMAND "GRADUA" NX00 DISgra)								; GRADUA SPLI-A
		(COMMAND "PUNTO" X-ultimo)									; PINTA Ultimo Punto A
	
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PX  Lon-LPA															
		(SETQ LIS-PX nil)											; LISTA  PUNTOS-A
		(SETQ LIS-PX (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PX))			; lista entidad -> (1 Punto-A)
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))						; Nombre entidad siguiente
			(COMMAND "BORRA" N-enti-A1 "")
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PX (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PX))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A

		;	LISTA ( LIS-PX ) Ordenada																		

		(SETQ LIS-PX  (REVERSE LIS-PX ))	; ( LIS-PX Ordenada )
		(SETQ N-PX  (LENGTH LIS-PX ))

		;																							


		;-----------------------------------------------------------------------------------------------------------------------------------------
		;	AADE MARGEN ( MAR ) <SOLAPE> a ( LIS-PX ) por DETRAS ( MAR ) Primeros y por DELANTE ( MAR ) Ultimos => ( LIS-PX+M* )			
		;																							
		;-----------------------------------------------------------------------------------------------------------------------------------------
		;																							
			(SETQ MAR 10 )	; N de PUNTOS QUE AADE A (LIS-PX) COMO MARGEN por DELANTE y por DETRAS => 2 x MAR => (LIS-PX+mar)			
		;																							
		;																							
		;-----------------------------------------------------------------------------------------------------------------------------------------



		;	AADE a ( LIS-PX Ordenada ) como PRIMEROS los ( MAR Ultimos) de ( LIS-PX Ordenada )			

		(SETQ LIS-PX+mar LIS-PX)

		(SETQ Nu 0)
		(REPEAT MAR
			(SETQ Nu (+ Nu 1))
			(SETQ LIS-PX+mar (CONS (NTH (- (LENGTH LIS-PX) Nu ) LIS-PX ) LIS-PX+mar ))
		) ;repe

		;	AADE a ( LIS-PX+M* Ordenada ) como ULTIMOS los ( MAR Primeros) de ( LIS-PX Ordenada )		

		(SETQ LIS-PX+mar (REVERSE LIS-PX+mar ))	; ( LIS-PX Invertida )

		(SETQ Np -1)
		(REPEAT MAR
			(SETQ Np (+ Np 1))
			(SETQ LIS-PX+mar (CONS (NTH Np LIS-PX ) LIS-PX+mar ))
		) ;repe

		;	LISTA ( LIS-PX+mar ) Ordenada																		

		(SETQ LIS-PX+mar (REVERSE LIS-PX+mar ))	; ( LIS-PX Ordenada )
		(SETQ N-PX+mar  (LENGTH LIS-PX+mar ))

		;																							


		;	PINTA PUNTOS de ( LIS-PINTA-P ) con Texto-N   (COMPROVACION)		

		; (SETQ LIS-PINTA-P LIS-PX     )  (PINTA-PUN)
		; (SETQ LIS-PINTA-P LIS-PX+mar )  (PINTA-PUN)	; CON MARGEN

		;													


	) ; Defun SPLI-X

;																									


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	Puntos ** TRAZA ** de PLANOS de Secciones (A) y (B) => (TRAZ-1) (TRAZ-2) (TRAZ-12)											
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	ENTRADA  : / NA00 / NB00 / 																				
;	INTERNAS : / Sa0 / Sa1 / Sa2 / Sa0b / Sa1b / Sa2b / Sb0 / Sb1 / Sb2 / TRAZ-2												
;	SALIDA   : / TRAZ-1 / TRAZ-12 /																			
;	GRAFICA  : LINEA ( TRAZ-1 TRAZ-2 )																			
;-----------------------------------------------------------------------------------------------------------------------------------------------------


	(DEFUN TRAZA-AB ( / )

		(COMMAND "SCP" "B" NA00 )		; PLANO S-a
 			(SETQ Sa0 (TRANS (LIST    0   0 0) 1 0))
 			(SETQ Sa1 (TRANS (LIST  100 100 0) 1 0))
 			(SETQ Sa2 (TRANS (LIST -100 100 0) 1 0))
		(COMMAND "SCP" "U")

		(COMMAND "SCP" "B" NB00 )		; PLANO S-b
 			(SETQ Sa0b (TRANS Sa0 0 1))
 			(SETQ Sa1b (TRANS Sa1 0 1))
 			(SETQ Sa2b (TRANS Sa2 0 1))
 			(SETQ Sb0 (TRANS (LIST (CAR Sa0b) (CADR Sa0b) 0) 1 0))
 			(SETQ Sb1 (TRANS (LIST (CAR Sa1b) (CADR Sa1b) 0) 1 0))
 			(SETQ Sb2 (TRANS (LIST (CAR Sa2b) (CADR Sa2b) 0) 1 0))
		(COMMAND "SCP" "U")


		(SETQ TRAZ-1  (INTERS Sa0 Sa1 Sb0 Sb1 nil))
		(SETQ TRAZ-2  (INTERS Sa0 Sa2 Sb0 Sb2 nil))

		(SETQ TRAZ-12 (LIST 	(+ (CAR   TRAZ-2) (/ (- (CAR   TRAZ-1) (CAR   TRAZ-2)) 2 ))		; PUNTO MEDIO 
						(+ (CADR  TRAZ-2) (/ (- (CADR  TRAZ-1) (CADR  TRAZ-2)) 2 ))
						(+ (CADDR TRAZ-2) (/ (- (CADDR TRAZ-1) (CADDR TRAZ-2)) 2 )) ) )

		(COMMAND "COLOR" 7 "LINEA" TRAZ-1 TRAZ-2 "" )

	) ; Defun TRAZA-AB

;																									


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	ANGULO con la TRAZA de la TANGENTE en P2 al CIRCULO OSCULADOR de P1 P2 P3	=>  LIS-AngX+1 = ( LIST AgT P2U DISx T2U )				
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	ENTRADA  : / TRAZ-12 / TRAZ-1 / LIS-P+mar /																	
;	INTERNAS : / LIS-AngX / Nag / P1U / P2U / P3U / P1 / P2 / P3 / M12 / M23 / CEN / T2 / AgT / DISx / AngX-primer / LIS-AngX*R / LIS-AngX+1*R /	
;	SALIDA   : / LIS-AngX+1 /																				
;-----------------------------------------------------------------------------------------------------------------------------------------------------


	(DEFUN ANG-PX ( / )

		(COMMAND "SCP" "3P" TRAZ-12 TRAZ-1 (NTH 0 LIS-P+mar) )								; PLANO TRAZ-SPLINE-X

			(SETQ LIS-AngX nil)
			(SETQ Nag -1 )
			(REPEAT (- (LENGTH LIS-P+mar) 2)

				(SETQ Nag (+ Nag 1))
				(SETQ P1U (NTH (+ Nag 0) LIS-P+mar))  (SETQ P1  (TRANS P1U 0 1))
				(SETQ P2U (NTH (+ Nag 1) LIS-P+mar))  (SETQ P2  (TRANS P2U 0 1))
				(SETQ P3U (NTH (+ Nag 2) LIS-P+mar))  (SETQ P3  (TRANS P3U 0 1))

				;	PUNTOS MEDIOS entre P1 P2 P3 => ( M12 M23 ) en SCP											

				(SETQ M12  (LIST (+ (CAR P1) (/ (- (CAR P2) (CAR P1)) 2)) (+ (CADR P1) (/ (- (CADR P2) (CADR P1)) 2)) 0))
				(SETQ M23  (LIST (+ (CAR P2) (/ (- (CAR P3) (CAR P2)) 2)) (+ (CADR P2) (/ (- (CADR P3) (CADR P2)) 2)) 0))

				;	PERPENDICULAR AL PUNTO MEDIO ( M12 M23 ) => ( P12 P23 ) en SCP									

				(SETQ P12 (LIST (+ (CAR M12) (- (CADR P2) (CADR M12)) ) (- (CADR M12) (- (CAR P2) (CAR M12)) ) 0))
				(SETQ P23 (LIST (+ (CAR M23) (- (CADR P3) (CADR M23)) ) (- (CADR M23) (- (CAR P3) (CAR M23)) ) 0))

				;	INTERSECCION PERPENDICULARES P-Mediaos (CENTRO CIRCULO OSCULADOR P1 P2 P3 ) => ( CEN )					

				(SETQ CEN (INTERS M12 P12  M23 P23 nil))	; SCP

				;	NORMAL AL RADIO ( P2 - CEN ) => TANGENTE ( P2 - T2 ) en SCP										

				(IF (/= CEN nil)
					(PROGN
						(SETQ T2 (LIST (- (CAR P2) (- (CADR P2) (CADR CEN)) ) (- (CADR P2) (- (CAR CEN) (CAR P2)) ) 0))

						(SETQ T2U (TRANS T2 1 0) )

						(SETQ AgT (ANGLE P2 T2 ))

						; (COMMAND "COLOR" COLO "LINEA" P2 T2 "")	; TANGENTE

						(SETQ DISx (CAR (INTERS P2 T2 (LIST 0 0 0) (LIST 10 0 0) nil) ))
						(SETQ LIS-AngX (CONS (LIST AgT P2U DISx T2U ) LIS-AngX))
					) ;progn
				) ;if IN
			) ; repeat
 
		(COMMAND "SCP" "U")

		;	LISTA ( LIS-AngX )																			

		(SETQ LIS-AngX+1 (REVERSE LIS-AngX))		; *** LIS-AngX+1 Ordenada *** 

		;																							

	) ; Defun ANG-PX

;																									


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	MARCA TRAMOS entre PUNTOS de INFLEXION y MAXIMOS y MINIMOS ( con CIRCULO y TEXTO)											
;	toma datos de ( LIS-AngX+1 )->(LIST AgT P2U DISx T2U ) =>															
;									=> debuelve ( LIS-TraTODO ) -> (( LIS-Tra0 )...( LIS-Tra0 )) -> ( LIST Ng1 Dg1 Pg1  Dg2 Pg2 )	
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	ENTRADA  : / LIS-Ang+1 /																				
;	INTERNAS : / LIS-TraX / LIS-Tra0 / Ng1 / LL1 / LL2 / Ag1 / Ag2 / Pg1 / Pg2 / Dg1 / Dg2 /										
;	SALIDA   : / LIS-TraX /																					
;	GRAFICA  : / CIRCULO ( Pg1 ) / CIRCULO ( Pg2 ) / TEXTO ( Pg1 ) / TEXTO ( Pg2 ) /											
;-----------------------------------------------------------------------------------------------------------------------------------------------------


	(DEFUN MARCA-Tramos ( / )


	;	(SETQ LIS-NLINITES nil) ; COMPROBACION


		(SETQ LIS-TraTODO nil)
		(SETQ LIS-TraMAX  nil)
		(SETQ LIS-TraESE  nil)

		(SETQ PRINER-MAX T)

		(SETQ Ng1 -1 )
		(REPEAT (- (LENGTH LIS-Ang+1) 1)

			(SETQ Ng1 (+ Ng1 1))
			(SETQ Ng2 (+ Ng1 1))

			(SETQ LL1 (NTH Ng1 LIS-Ang+1))	; (LIST AgT P2U DISx T2U )
			(SETQ LL2 (NTH Ng2 LIS-Ang+1))

			(SETQ Ag1 (NTH 0 LL1))	; Angulo Tang en TRAZA
			(SETQ Ag2 (NTH 0 LL2))

			(SETQ Pg1 (NTH 1 LL1))	; Punto P2U (Tang P2U T2U)
			(SETQ Pg2 (NTH 1 LL2))

			(SETQ Dg1 (NTH 2 LL1))	; Distancia a la INTERSECCION de TANG en TRAZA
			(SETQ Dg2 (NTH 2 LL2))

			(SETQ Tg1 (NTH 3 LL1))	; Punto T2U (Tang P2U T2U)
			(SETQ Tg2 (NTH 3 LL2))

			;																						
			;	( LIS-TraESE ) => (LIST Ng1 Dg1 Pg1) o (LIST Ng2 Dg2 Pg2)												
			;																						



			;	PUNTOS MEDIOS entre Pg1 Pg2  => ( Mg12  ) 														

			(SETQ Mg12  (LIST (+ (CAR   Pg1) (/ (- (CAR   Pg2) (CAR   Pg1)) 2))
						(+ (CADR  Pg1) (/ (- (CADR  Pg2) (CADR  Pg1)) 2))
						(+ (CADDR Pg1) (/ (- (CADDR Pg2) (CADDR Pg1)) 2)) ))

			;	POR CADA DOS CUADRANDES 																	
			(COND
				( (OR (= Ag1 0 ) (= Ag1 PI ) (= Ag1 (* 2 PI)) )
					(COMMAND "COLOR" 7  "CIRCULO" Pg1 0.03 )
					(PROMPT " ****** ( TANG-1 ) => PARALELA a TRAZA en Ng1 = ") 	(PRIN1 Ng1) (TERPRI) )

				( (OR (= Ag2 0 ) (= Ag2 PI ) (= Ag2 (* 2 PI)) )
					(COMMAND "COLOR" 7  "CIRCULO" Pg2 0.03 )
					(PROMPT " ****** ( TANG-2 ) => PARALELA a TRAZA en Ng1 = ") 	(PRIN1 Ng1) (TERPRI) )

				( (OR (= Ag1 (* (/ 1.0 2.0) PI) ) (= Ag1 (* (/ 3.0 2.0) PI)) )
					(COMMAND "COLOR" 7  "CIRCULO" Pg1 0.03 )
					(PROMPT " ****** ( TANG-1 ) => PERTENDICULAR a TRAZA en Ng1 = ") 	(PRIN1 Ng1) (TERPRI) )

				( (OR (= Ag2 (* (/ 1.0 2.0) PI) ) (= Ag2 (* (/ 3.0 2.0) PI)) )
					(COMMAND "COLOR" 7  "CIRCULO" Pg2 0.03 )
					(PROMPT " ****** ( TANG-2 ) => PERTENDICULAR a TRAZA en Ng1 = ") 	(PRIN1 Ng1) (TERPRI) )


				( (OR (AND (< (* 0 PI)  Ag1  (* 1 PI) ) (< (* 1 PI) Ag2 (* 2 PI)))	; (Ag1) Emcima y (Ag2) Debajo del EJE-X
				      (AND (< (* 0 PI)  Ag2  (* 1 PI) ) (< (* 1 PI) Ag1 (* 2 PI))) )	; (Ag1) Debajo y (Ag2) Emcima del EJE-X

					(COND

						;	(Ag1) y (Ag2) al MISMO LADO del EJE-Y  =>       (1) PUNTO DE MAXIMO O MINIMO (MAX) 1				

						( (AND (= PRINER-MAX T)
							(OR (AND (< (* 0.5 PI)  Ag1  (* 1.5 PI)) (< (* 0.5 PI) Ag2 (* 1.5 PI)) )	; (Ag1)(Ag2) en 2-3 Cuadrante
						 	    (AND (OR (< (* 0.0 PI)  Ag1  (* 0.5 PI)) (< (* 1.5 PI) Ag1 (* 2.0 PI)) )	; (Ag1)(Ag2) en 1-4 Cuadrante
								   (OR (< (* 0.0 PI)  Ag2  (* 0.5 PI)) (< (* 1.5 PI) Ag2 (* 2.0 PI)) ))))

							(COMMAND "COLOR" 2 "CIRCULO" "2P" Pg1 Pg2  "CIRCULO" Mg12 0.04 )			; MAXIMOS O MINIMOS
							(COMMAND "COLOR" COLO "TEXTO" Pg1 0.04 90 Ng1  "TEXTO" Pg2 0.04 90 Ng2 )

							(SETQ LIS-TraTODO nil)
							(SETQ LIS-TraMAX  nil)
							(SETQ LIS-TraESE  nil)

							(SETQ LIS-TraESE (CONS (LIST Ng2 Dg2 Pg2) LIS-TraESE) ) ;****************
							(SETQ Nsegun  Ng2)

							(SETQ PRINER-MAX nil)

							(SETQ P-ULTIMO Pg2)
						)

						;	(Ag1) y (Ag2) al MISMO LADO del EJE-Y  =>       (NO 1) PUNTOS DE MAXIMO O MINIMO (MAX) no1			

						( (AND (= PRINER-MAX nil)
							(OR (AND (< (* 0.5 PI)  Ag1  (* 1.5 PI)) (< (* 0.5 PI) Ag2 (* 1.5 PI)) )	; (Ag1)(Ag2) en 2-3 Cuadrante
						          (AND (OR (< (* 0.0 PI)  Ag1  (* 0.5 PI)) (< (* 1.5 PI) Ag1 (* 2.0 PI)) )	; (Ag1)(Ag2) en 1-4 Cuadrante
							         (OR (< (* 0.0 PI)  Ag2  (* 0.5 PI)) (< (* 1.5 PI) Ag2 (* 2.0 PI)) ))))

							(COMMAND "COLOR" 2 "CIRCULO" "2P" Pg1 Pg2  "CIRCULO" Mg12 0.04 )			; MAXIMOS O MINIMOS
							(COMMAND "COLOR" COLO "TEXTO" Pg1 0.04 90 Ng1  "TEXTO" Pg2 0.04 90 Ng2 )

							(IF (EQUAL Pg1 P-ULTIMO)

								(PROGN
									(SETQ LIS-TraESE  (CONS (LIST Ng1 Dg1 Pg1) LIS-TraESE) ) ;****************
									(SETQ LIS-TraMAX  (CONS (REVERSE LIS-TraESE) LIS-TraMAX) )
									(SETQ LIS-TraTODO (CONS (REVERSE LIS-TraMAX) LIS-TraTODO) )
								) ;progn

								(PROGN
									(SETQ LIS-TraESE  (CONS (LIST Ng1 Dg1 Pg1) LIS-TraESE) ) ;****************
									(SETQ LIS-TraMAX  (CONS (REVERSE LIS-TraESE) LIS-TraMAX) )
									(SETQ LIS-TraTODO (CONS (REVERSE LIS-TraMAX) LIS-TraTODO) )
									(SETQ LIS-TraESE  nil )
									(SETQ LIS-TraMAX  nil )

									(SETQ LIS-TraESE  (CONS (LIST Ng2 Dg2 Pg2) LIS-TraESE) ) ;****************
									(SETQ Nsegun  Ng2)

								) ;progn
							) ;if
						)

						;	(Ag1) y (Ag2) a DISTINTO LADO del EJE-Y  =>     PUNTOS DE INFLESION (ESE)						

						( (OR (AND (< (* 0.5 PI)  Ag1  (* 1.5 PI)) (OR (< (* 0.0 PI)  Ag2  (* 0.5 PI)) (< (* 1.5 PI) Ag2 (* 2.0 PI)) ) )
							(AND (< (* 0.5 PI)  Ag2  (* 1.5 PI)) (OR (< (* 0.0 PI)  Ag1  (* 0.5 PI)) (< (* 1.5 PI) Ag1 (* 2.0 PI)) ) ) )

							(COMMAND "COLOR" 4 "CIRCULO" "2P" Pg1 Pg2  "CIRCULO" Mg12 0.04 )			; INFLESION
							(COMMAND "COLOR" COLO "TEXTO" Pg1 0.04 90 Ng1  "TEXTO" Pg2 0.04 90 (+ Ng1 1) )


							(SETQ LIS-TraESE (CONS (LIST Ng1 Dg1 Pg1) LIS-TraESE) ) ;****************
							(SETQ LIS-TraMAX (CONS (REVERSE LIS-TraESE) LIS-TraMAX) )

							(SETQ LIS-TraESE nil )
							(SETQ LIS-TraESE (CONS (LIST Ng2 Dg2 Pg2) LIS-TraESE) ) ;****************
							(SETQ Nsegun  Ng2)
						)
					
					) ;con
				)


				;	(PROMPT " *** ANGULOS NO SIGULARES en Ng1 = ") (PRIN1 Ng1) (TERPRI)									

				(  T  (IF (NOT (EQUAL Ng1 Nsegun)) (SETQ LIS-TraESE (CONS (LIST Ng1 Dg1 Pg1) LIS-TraESE)) ) ) ;****************

			) ;con

		) ;repeat

		(SETQ LIS-TraTODO (REVERSE LIS-TraTODO) )

	) ; Defun MARCA-Tramos


;																									



;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	IGUALA   NListas (TRAMOS-ESE)  de  Listas (LISTAS-MAX)  de las  DOS Listas (LISTAS-TODO)										
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;		(LIS-TraTODO-A) => ( (LmaxA) ... ... (LmaxA) )	(NL.maxA) = (LENGTH LIS-TraTODO-A)										
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;		(LmaxA)     => ( (LIS-ese-A) ... ... (LIS-ese-A) )	(NL.eseA) = (LENGTH LmaxA)										
;=====================================================================================================================================================
;																									
;	ELIMINA LISTAS (LIS-ese-A) o (LIS-ese-A) MAS CORTAS  PARA QUE (NL.eseA = NL.eseB) EN CAPA PAR DE ((LmaxA)-(LmaxB))					
;																									
;-----------------------------------------------------------------------------------------------------------------------------------------------------

	(DEFUN ELIMINA-LISTAS ( / )

		(IF (= (LENGTH LIS-TraTODO-A) (LENGTH LIS-TraTODO-B) )
			(PROGN

				(SETQ LIS-ORDEN-A nil )
				(SETQ LIS-ORDEN-B nil )

				(SETQ Ne -1)
				(REPEAT (LENGTH LIS-TraTODO-A)

					(SETQ Ne (+ Ne 1))

					(SETQ LmaxA (NTH Ne LIS-TraTODO-A) )
					(SETQ LmaxB (NTH Ne LIS-TraTODO-B) )

					(SETQ NmaxA (LENGTH LmaxA) )
					(SETQ NmaxB (LENGTH LmaxB) )

					(COND

					   ;--------------------------------------------------------------------------------------
					   ;	(1) IGUALES											(1) IGUALES	

					   (  (= NmaxA NmaxB )

						(SETQ LIS-ORDEN-A (CONS LmaxA  LIS-ORDEN-A ))
						(SETQ LIS-ORDEN-B (CONS LmaxB  LIS-ORDEN-B ))

					   ) ;(1) IGUALES		

					   ;--------------------------------------------------------------------------------------
					   ;	(2) MAYOR											(2) MAYOR	

					   (  (> NmaxA NmaxB )

						(SETQ LmaxA2  LmaxA)
						(SETQ NmaxA2  NmaxA )

						(SETQ WWWA T )
						(WHILE WWWA

						   (IF (= NmaxA2  NmaxB )

							(PROGN
								(SETQ WWWA nil)
								(SETQ LIS-ORDEN-A (CONS LmaxA2 LIS-ORDEN-A ))
								(SETQ LIS-ORDEN-B (CONS LmaxB  LIS-ORDEN-B ))
							) ;pro

							(PROGN
								(SETQ NNAm nil)
								(SETQ NA-menor 10000)
								(SETQ NA2 -1)			; NO LISTAS EXTREMOS (NO N-PRINERO) => (SETQ NA2 0)
								(REPEAT NmaxA2			; NO LISTAS EXTREMOS (NO N-ULTIMO ) => (REPEAT (- NmaxA2 1)
									(SETQ NA2 (+ NA2 1))

									(IF (< (LENGTH (NTH NA2 LmaxA2)) NA-menor )
										(SETQ NA-menor (LENGTH (NTH NA2 LmaxA2)) NNAm NA2)
									) ;if
								) ;repe

								(SETQ LmaxA1 nil)
								(SETQ NA1    -1 )
								(REPEAT NmaxA2
									(SETQ NA1 (+ NA1 1))

									(IF (/= NA1 NNAm)
										(SETQ LmaxA1 (CONS (NTH NA1 LmaxA2) LmaxA1))
									) ;if
								) ;repe

								(SETQ LmaxA2 (REVERSE LmaxA1))
								(SETQ NmaxA2 (LENGTH  LmaxA2))
							) ;pro
						   ) ;if
						) ;whi
					   ) ;(2) MAYOR		

					   ;--------------------------------------------------------------------------------------
					   ;	(3) MENOR											(3) MENOR	

					   (  (< NmaxA NmaxB )

						(SETQ LmaxB2 LmaxB)
						(SETQ NmaxB2 NmaxB )

						(SETQ WWWB T )
						(WHILE WWWB

						   (IF (= NmaxB2  NmaxA )

							(PROGN
								(SETQ WWWB nil)
								(SETQ LIS-ORDEN-A (CONS LmaxA  LIS-ORDEN-A ))
								(SETQ LIS-ORDEN-B (CONS LmaxB2 LIS-ORDEN-B ))
							) ;pro

							(PROGN
								(SETQ NNBm nil)
								(SETQ NB-menor 10000)
								(SETQ NB2 -1)			; NO LISTAS EXTREMOS (NO N-PRINERO) => (SETQ NB2 0)
								(REPEAT NmaxB2			; NO LISTAS EXTREMOS (NO N-ULTIMO ) => (REPEAT (- NmaxB 1)
									(SETQ NB2 (+ NB2 1))

									(IF (< (LENGTH (NTH NB2 LmaxB2)) NB-menor )
										(SETQ NB-menor (LENGTH (NTH NB2 LmaxB2)) NNBm NB2)
									) ;if
								) ;repe

								(SETQ  LmaxB1 nil)
								(SETQ NB1 -1)
								(REPEAT NmaxB2
									(SETQ NB1 (+ NB1 1))

									(IF (/= NB1 NNBm)
										(SETQ LmaxB1 (CONS (NTH NB1 LmaxB2) LmaxB1))
									) ;if
								) ;repe

								(SETQ LmaxB2 (REVERSE LmaxB1))
								(SETQ NmaxB2 (LENGTH  LmaxB2))
							) ;pro
						   ) ;if
						) ;whi
					   ) ;(3) MENOR		
					) ;con
				) ;repe

				(SETQ LIS-ORDEN-A (REVERSE LIS-ORDEN-A))
				(SETQ LIS-ORDEN-B (REVERSE LIS-ORDEN-B))
			) ;pro

			(PROGN
				(PROMPT "  N de LISTAS de (LIS-TraTODO-A) NO IGUAL al de (LIS-TraTODO-B) !ERROR ") (TERPRI)
			) ;pro
		) ;if

	) ; ELIMINA-LISTAS

;																									



;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	PINTAMOS 3D-CARAS en 3D y 2D ( PLANIFICA ( 3DC NO PLANAS ) PROYECTANDO 3A2 sobre ( 3B1 3A1 3B2 ))								
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	ENTRADA  : / 3A1 / 3A2 / 3B1 / 3B2 / 2KKA / 2KKB /																
;	INTERNAS : / 2A1a / 2B1a / 2B2a / 2A2a / 2A1 / 2B1 / 2A2 / 2B2 / 2KKA / 2KKB /											
;	SALIDA   : 																							
;	GRAFICA  : / LINEA ( 2A1 2A2 ) / LINEA ( 2B1 2B2 ) / LINEA ( 2A1 2B1 ) / LINEA ( 2A2 2B2 ) / 3DCARA ( 3A1 3B1 3B2 3A2 ) /				
;-----------------------------------------------------------------------------------------------------------------------------------------------------


(DEFUN PINTA-3DC ( / )

	(COND

		;  (1)   CUADRO LADOS 3DCara  ***************************************************************************************

		( (AND (NOT (EQUAL 3A1 3A2)) (NOT (EQUAL 3B1 3B2)) )

			(COMMAND "SCP" "3P" 3B1 3A1 3B2)		; SCP-A
				(SETQ 2A1a (TRANS 3A1 0 1))
				(SETQ 2B1a (TRANS 3B1 0 1))
				(SETQ 2B2a (TRANS 3B2 0 1))
				(SETQ 2A2a (LIST (CAR (TRANS 3A2 0 1)) (CADR (TRANS 3A2 0 1)) 0) ) ; PROYECTA sobre Plano SCP-A
			(COMMAND "SCP" "U")

			(COMMAND "SCP" "3P" 2KKB 2KKA "")		; SCP-2D
				(SETQ 2A1 (TRANS 2A1a 1 0))
				(SETQ 2B1 (TRANS 2B1a 1 0))
				(SETQ 2A2 (TRANS 2A2a 1 0))
				(SETQ 2B2 (TRANS 2B2a 1 0))
			(COMMAND "SCP" "U")

			(IF (EQUAL 2KKB (LIST 0 0 0) 0.00001)			; PINTA SOLO LA PRINERA

				(PROGN 
					;	PINTA en 2D				
					(COMMAND "COLOR" 5 "TEXTO" (LIST -0.85 -0.46 0) 0.3 90 NCapa)	; TEXTO en Patron (N CAPA)
					(SETQ TXT-CAPA (ENTLAST))
			  		(COMMAND "COLOR" 7 "LINEA" 2A1 2B2 "" )	; PINTA ASPA NEGRA
			  		(COMMAND "COLOR" 7 "LINEA" 2B1 2A2 "" )
			  		(COMMAND "COLOR" 7 "LINEA" 2A1 2B1 "" )	; PINTA 1 GENERATRIZ
			  		(COMMAND "COLOR" 8 "LINEA" 2A2 2B2 "" )	; PINTA 2 GENERATRIZ
					(COMMAND "COLOR" 1 "LINEA" 2A1 2A2 "" )	; PINTA (Color 1 y 5) DELANTE (Color 8)
					(COMMAND "COLOR" 5 "LINEA" 2B1 2B2 "" )
					;	PINTA en 3D				
			  		(COMMAND "COLOR" 7 "LINEA"  3A1 3B2 "" )	; PINTA ASPA NEGRA
			  		(COMMAND "COLOR" 7 "LINEA"  3B1 3A2 "" )
					(COMMAND "COLOR" 2 "3DCARA" 3A1 3B1 3B2 3A2 "" )
			  		(COMMAND "COLOR" 7 "LINEA"  3A1 3B1 "" )	; PINTA 1 GENERATRIZ
				) ;pro

				(PROGN 
					;	PINTA en 2D				
			  		(COMMAND "COLOR" 8 "LINEA" 2A2 2B2 "" )	; PINTA SIGUIENTES 2 GENERATRIZ
					(COMMAND "COLOR" 1 "LINEA" 2A1 2A2 "" )	; PINTA (Color 1 y 5) DELANTE (Color 8)
					(COMMAND "COLOR" 5 "LINEA" 2B1 2B2 "" )
					;	PINTA en 3D				
					(COMMAND "COLOR" 2 "3DCARA" 3A1 3B1 3B2 3A2 "" )
				) ;pro
			) ;if

			(SETQ 2KKB 2B2 2KKA 2A2)
		)

		;  (2)   TRES LADOS 3DCara  ***************************************************************************************

		( (EQUAL 3A1 3A2)		; EL LADO (3A1 3A2) NO ESISTE 

			(COMMAND "SCP" "3P" 3B1 3A1 3B2)		; SCP-A
				(SETQ 2A1a (TRANS 3A1 0 1))
				(SETQ 2B1a (TRANS 3B1 0 1))
				(SETQ 2B2a (TRANS 3B2 0 1))
			(COMMAND "SCP" "U")

			(COMMAND "SCP" "3P" 2KKB 2KKA "")		; SCP-2D
				(SETQ 2A1 (TRANS 2A1a 1 0))
				(SETQ 2B1 (TRANS 2B1a 1 0))
				(SETQ 2B2 (TRANS 2B2a 1 0))
			(COMMAND "SCP" "U")

			(IF (EQUAL 2KKB (LIST 0 0 0) 0.00001)		; PINTA SOLO LA PRINERA

				(PROGN 
					;	PINTA en 2D				
					(COMMAND "COLOR" 5 "TEXTO" (LIST -0.85 -0.46 0) 0.3 90 NCapa)	; TEXTO en Patron (N CAPA)
					(SETQ TXT-CAPA (ENTLAST))
			  		(COMMAND "COLOR" 7 "LINEA" 2A1 2B1 "" )	; PINTA 1 GENERATRIZ
			  		(COMMAND "COLOR" 8 "LINEA" 2A1 2B2 "" )	; PINTA 2 GENERATRIZ
					(COMMAND "COLOR" 5 "LINEA" 2B1 2B2 "" )	; PINTA (Color 1 y 5) DELANTE (Color 8)
					;	PINTA en 3D				
					(COMMAND "COLOR" 2 "3DCARA" 3A1 3B1 3B2 3A2 "" )
			  		(COMMAND "COLOR" 7 "LINEA"  3A1 3B1 "" )	; PINTA 1 GENERATRIZ
				) ;pro

				(PROGN 
					;	PINTA en 2D				
			  		(COMMAND "COLOR" 8 "LINEA" 2A1 2B2 "" )	; PINTA SIGUIENTES 2 GENERATRIZ
					(COMMAND "COLOR" 5 "LINEA" 2B1 2B2 "" )	; PINTA (Color 1 y 5) DELANTE (Color 8)
					;	PINTA en 3D				
					(COMMAND "COLOR" 2 "3DCARA" 3A1 3B1 3B2 3A2 "" )
				) ;pro
			) ;if

			(SETQ 2KKB 2B2 2KKA 2A1)
		)

		;  (3)   TRES LADOS 3DCara  ***************************************************************************************

		( (EQUAL 3B1 3B2)		; EL LADO (3B1 3B2) NO ESISTE 

			(COMMAND "SCP" "3P" 3B1 3A1 3A2)		; SCP-A
				(SETQ 2A1a (TRANS 3A1 0 1))
				(SETQ 2B1a (TRANS 3B1 0 1))
				(SETQ 2A2a (TRANS 3A2 0 1))
			(COMMAND "SCP" "U")

			(COMMAND "SCP" "3P" 2KKB 2KKA "")		; SCP-2D
				(SETQ 2A1 (TRANS 2A1a 1 0))
				(SETQ 2B1 (TRANS 2B1a 1 0))
				(SETQ 2A2 (TRANS 2A2a 1 0))
			(COMMAND "SCP" "U")

			(IF (EQUAL 2KKB (LIST 0 0 0) 0.00001)		; PINTA SOLO LA PRINERA

				(PROGN 
					;	PINTA en 2D				
					(COMMAND "COLOR" 5 "TEXTO" (LIST -0.85 -0.46 0) 0.3 90 NCapa)	; TEXTO en Patron (N CAPA)
					(SETQ TXT-CAPA (ENTLAST))
			  		(COMMAND "COLOR" 7 "LINEA" 2A1 2B1 "" )	; PINTA 1 GENERATRIZ
			  		(COMMAND "COLOR" 8 "LINEA" 2A2 2B1 "" )	; PINTA 2 GENERATRIZ
					(COMMAND "COLOR" 1 "LINEA" 2A1 2A2 "" )	; PINTA (Color 1 y 5) DELANTE (Color 8)
					;	PINTA en 3D				
					(COMMAND "COLOR" 2 "3DCARA" 3A1 3B1 3B2 3A2 "" )
			  		(COMMAND "COLOR" 7 "LINEA"  3A1 3B1 "" )	; PINTA 1 GENERATRIZ
				) ;pro

				(PROGN 
					;	PINTA en 2D				
			  		(COMMAND "COLOR" 8 "LINEA" 2A2 2B1 "" )	; PINTA SIGUIENTES 2 GENERATRIZ
					(COMMAND "COLOR" 1 "LINEA" 2A1 2A2 "" )	; PINTA (Color 1 y 5) DELANTE (Color 8)
					;	PINTA en 3D				
					(COMMAND "COLOR" 2 "3DCARA" 3A1 3B1 3B2 3A2 "" )
				) ;pro
			) ;if

			(SETQ 2KKB 2B1 2KKA 2A2)
		)
		
		( (AND (EQUAL 3A1 3A2) (EQUAL 3B1 3B2) )  (TERPRI) (PROMPT "  3DCARA ES UNA LINEA ") (TERPRI) )

		(  T  (TERPRI) (PROMPT "  *** NO CUMPLE CONDICIONES *** ") (TERPRI) )

	) ;cond

) ; PINTA-3DC

;																									



;-----------------------------------------------------------------------------------------------------------------------------------------------------
;		( LIS-ORDEN-A ) => ( (LmaxA) ... ... ... ... ... (LmaxA) )														
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;		( LmaxA )       => ( (LIS-ese-A) ... ... ... (LIS-ese-A) )														
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;		( LIS-ese-A )   => ( ( (Ng Dg Pg)   ...  ...  (Ng Dg Pg) )														
;=====================================================================================================================================================
;	BUSCA DISTANCIA (A) QUE SE ENCUENTRE ENTRE DOS DE (B) CONSICUTIBAS  =>  PINTA LINEA Entre PUNT-MEDIO de (Bs) y PUNTO (A)				
;	COPIA la PRIMERA (1Paraja Puntos) EL ULTIMO		LIS-3DC => (LIST Pa1 Pb12 )											
;	MANDA PINTAR  3D-CARAS en 3D y 2D		(3DCARA => 3A1 3B1 3B2 3A2)													
;-----------------------------------------------------------------------------------------------------------------------------------------------------

	(DEFUN BUSCA-DISTANCIA ( / )

			(SETQ LIS-3DC nil)

			(SETQ Na1 -1)
			(REPEAT (LENGTH LIS-ORDEN-A)						; (LENGTH LIS-ORDEN-A) = (LENGTH LIS-ORDEN-B)
				(SETQ Na1 (+ Na1 1))
				(SETQ LmaxA (NTH Na1 LIS-ORDEN-A))
				(SETQ LmaxB (NTH Na1 LIS-ORDEN-B))

				(SETQ Nab1 -1)
				(REPEAT (LENGTH LmaxA)						; (LENGTH LmaxA) = (LENGTH LmaxB)
					(SETQ Nab1 (+ Nab1 1))
					(SETQ LeseA (NTH Nab1 LmaxA))
					(SETQ LeseB (NTH Nab1 LmaxB))

					(SETQ Na2 -1)
					(REPEAT (LENGTH LeseA)
						(SETQ Na2 (+ Na2 1))
						(SETQ LeeA (NTH Na2 LeseA))			; (Ng Dg Pg)

						(SETQ Na1 (NTH 0 LeeA))
						(SETQ Da1 (NTH 1 LeeA))
						(SETQ Pa1 (NTH 2 LeeA))

						(SETQ Nb2 -1)
						(REPEAT (- (LENGTH LeseB) 1)
							(SETQ Nb2 (+ Nb2 1))
							(SETQ LeeB1 (NTH    Nb2    LeseB))	; (Ng Dg Pg)
							(SETQ LeeB2 (NTH (+ Nb2 1) LeseB))	; (Ng Dg Pg)

							(SETQ Nb1 (NTH 0 LeeB1))
							(SETQ Db1 (NTH 1 LeeB1))
							(SETQ Pb1 (NTH 2 LeeB1))

							(SETQ Nb2 (NTH 0 LeeB2))
							(SETQ Db2 (NTH 1 LeeB2))
							(SETQ Pb2 (NTH 2 LeeB2))

							(COND
								(  (> Db1 Da1 Db2)

									(SETQ Pb12 (LIST  (+ (CAR   Pb2) (/ (- (CAR   Pb1) (CAR   Pb2)) 2))
												(+ (CADR  Pb2) (/ (- (CADR  Pb1) (CADR  Pb2)) 2))
												(+ (CADDR Pb2) (/ (- (CADDR Pb1) (CADDR Pb2)) 2)) ))

								;	(COMMAND "COLOR" 2  "LINEA" Pa1 Pb12 "")

									(SETQ LIS-3DC (CONS (LIST Pa1 Pb12 ) LIS-3DC) )
								)

								(  (< Db1 Da1 Db2)

									(SETQ Pb12 (LIST  (+ (CAR   Pb2) (/ (- (CAR   Pb1) (CAR   Pb2)) 2))
												(+ (CADR  Pb2) (/ (- (CADR  Pb1) (CADR  Pb2)) 2))
												(+ (CADDR Pb2) (/ (- (CADDR Pb1) (CADDR Pb2)) 2)) ))

								;	(COMMAND "COLOR" 3  "LINEA" Pa1 Pb12 "")

									(SETQ LIS-3DC (CONS (LIST Pa1 Pb12 ) LIS-3DC) )
								)
							) ;con
						) ;repe Nb2
					) ;repe Na2
				) ;repe Nab1
			) ;repe Na1

		;	COPIA la PRIMERA (1Paraja Puntos) EL ULTIMO		LIS-3DC => (LIST Pa1 Pb12 )									

		(SETQ LIS-3DC (CONS (NTH (- (LENGTH LIS-3DC) 1) LIS-3DC ) LIS-3DC) )

		(SETQ LIS-3DC (REVERSE LIS-3DC))

		;	MANDA PINTAR  3D-CARAS en 3D y 2D		(3DCARA => 3A1 3B1 3B2 3A2)											

		(SETQ 2KKA (LIST -1 0 0))
		(SETQ 2KKB (LIST  0 0 0))

		(SETQ N3d -1)
		(REPEAT (- (LENGTH LIS-3DC) 1)

			(SETQ N3d (+ N3d 1))

			(SETQ 3A1 (NTH 0 (NTH (+ N3d 0) LIS-3DC)))
			(SETQ 3B1 (NTH 1 (NTH (+ N3d 0) LIS-3DC)))
			(SETQ 3A2 (NTH 0 (NTH (+ N3d 1) LIS-3DC)))
			(SETQ 3B2 (NTH 1 (NTH (+ N3d 1) LIS-3DC)))		;(COMMAND "COLOR" 2  "3DCARA" 3A1 3B1 3B2 3A2 "")

			(PINTA-3DC)

		) ;repeat

		(COMMAND "ORDENAOBJETOS" TXT-CAPA "" "D" )			; PONE (TXT-CAPA) DELANTE VISUAL

	) ; BUSCA-DISTANCIA

;																									





;=====================================================================================================================================================
;=====================================================================================================================================================
;																									
;	  *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA ***		
;																									
;=====================================================================================================================================================
;=====================================================================================================================================================
;																									
;		ENTRADA  : / NCapa / NA00 / NB00 /  /
;		INTERNAS : /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /
;		SALIDA   : 
;-----------------------------------------------------------------------------------------------------------------------------------------------------


(DEFUN C:PIEL-09 (/ )
  
	;	ARRANCANDO																						
	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND "-REFENT" "DES"  "SCP" "U"  "ORTO" "DES")


	;-----------------------------------------------------------------------------------------------------------------------------------------------
	;	FIJA PARAMETROS																					
	;-----------------------------------------------------------------------------------------------------------------------------------------------
	;																								
				(SETQ DISgra  0.07 )		; DISTANCIA para GRADUA  0.07												
	;																								
	;-----------------------------------------------------------------------------------------------------------------------------------------------


	;	NOMBRE DE CAPAS																					
	(SETQ NCapa  (GETINT " NOMBRE de CAPA ( 2000 ? ) = ")) (TERPRI)					; N NOMBRE DE 1 CAPA
	(SETQ NCapa (- NCapa 1))

	(TERPRI) (SETQ NA00  (CAR (ENTSEL" MARCA --- SPLINE ABIERTA-3D --- SECCION-A ? "))) 	; nombre Spline A 

	(SETQ Wca T)
	(WHILE Wca

		(SETQ NCapa (+ NCapa 1))
		(COMMAND "CAPA" "E" NCapa "") 									; crea y activa CAPA NCapa

		;	SELECCCION DE SECCIONES																			

		(TERPRI) (SETQ NB00  (CAR (ENTSEL" MARCA --- SPLINE ABIERTA-3D --- SECCION-B ? "))) ; nombre Spline B 

		;	GRADUA ( SPLINE-X ) con ( DISgra ) =>  (LENGTH LIS-PX+2)													

		(TERPRI) (SETQ NX00 NA00  COLO 1 TEX "A" )  (SPLI-X)  (SETQ  LIS-PA LIS-PX   LIS-PA+mar LIS-PX+mar )	; (LENGTH LIS-PA) 
		(TERPRI) (SETQ NX00 NB00  COLO 5 TEX "B" )  (SPLI-X)  (SETQ  LIS-PB LIS-PX   LIS-PB+mar LIS-PX+mar )	; (LENGTH LIS-PB) 

		;	INTERSECCION PLANOS SPLINE-A SPLINE-B => (TRAZ-1) (TRAZ-2)													
  
		(TRAZA-AB)													; DETERMINA INTERSECCION DE PLANOS DE SECCIONES

		;	TANGENTE CIRTULO OSCULADO 3-Punto-X ( LIS-AngX+1 ) => (LIST AgT P2U DISx T2U)										

		(SETQ LIS-P+mar LIS-PA+mar   COLO 1 ) (ANG-PX) (SETQ LIS-AngA+1 LIS-AngX+1)
		(SETQ LIS-P+mar LIS-PB+mar   COLO 5 ) (ANG-PX) (SETQ LIS-AngB+1 LIS-AngX+1)

		;																							
		;	LOCALIZA PUNTOS (MAXIMOS MINIMOS) e (INFLEXION)  PINTA CIRCULOS Y N DE LOS PUNTOS									
		;																							
		;	=> (LIS-TraTODO) ( SUBLISTA de TODOS los TRAMOS ) 														
		;										(LIS-TraTODO-A) 	=> ( (LmaxA) ... ... ... (LmaxA) )					
		;										(LmaxA)     	=> ( (LIS-ese-A) ... ... (LIS-ese-A) )				
		;										(LIS-ese-A) 	=> (  LIST Ng1 Dg1 Pg1 )						
		;																							

		(SETQ LIS-Ang+1 LIS-AngA+1   COLO 1 ) (MARCA-Tramos) 	(SETQ LIS-TraTODO-A  LIS-TraTODO)		; (LENGTH LIS-TraTODO-A)
		(SETQ LIS-Ang+1 LIS-AngB+1   COLO 5 ) (MARCA-Tramos) 	(SETQ LIS-TraTODO-B  LIS-TraTODO)		; (LENGTH LIS-TraTODO-A)

		;																							

	;	(ELIMINA-LISTAS)		; IGUALA NListas

	;	(BUSCA-DISTANCIA)		; PINTA 3DCARA en 3D y 2D

		;																							

		(TERPRI) (SETQ NW1 (GETSTRING "QUIERE SEGUIR (S) o N : "))

		(IF (EQUAL NW1 "N")
			(SETQ  Wca nil           )
			(SETQ  Wca  T  NA00 NB00 ))

	) ;CIERRE WHILE Wca
  
	;																								

	;	PARANDO																						
	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)

) ;CIERRE DEFUN PIEL-09

;=====================================================================================================================================================

